require 'sketchup' # First we pull in the standard API hooks.
require 'ShaDe//lib//main-structures.rb'
require 'ShaDe//lib//utils.rb'
require 'ShaDe//lib//interfaces//guitools.rb'
require 'ShaDe//lib//layers.rb'

# Show the Ruby Console at startup so we can
# see any programming errors we may make.
#Sketchup.send_action "showRubyPanel:"

# MAIN CODE ################################################################
# Add a menu item to launch our plugin, and prepare the plugin variables
menu = UI::menu("Plugins");
menu.add_separator;
menu.add_item("Practica Proyectos Arquitectonicos 6") {

	#We open a new file
	Sketchup.file_new
	
	#We are inside SketchUp
	Shade.using_sketchup = true

	Shade.modified=(false)	

	Shade.grammar_loaded=("")
			
	#We set the size of labels
	Shade.label_radius = Constants::LABEL_RADIUS
	
	#We prepare the SU canvas
	ShadeUtils.prepare_canvas
	
	#Create the default project
	ShadeUtils.create_default_project
	
	create_general_toolbar()
	
	#Add the close observer
#	close_observer = CloseObserver.new
#	Sketchup.add_observer(close_observer)
	
	#Add the undo observer
	undo_observer = UndoObserver.new
	Sketchup.active_model.add_observer(undo_observer)
	
	#Add the layers observer
	layers_observer = ShaDeLayersObserver.new
	Sketchup.active_model.layers.add_observer(layers_observer)

	rule_ob = RuleSelectionObserver.new()
	Shade.rule_ob=(rule_ob)
  Sketchup.active_model.selection.add_observer(rule_ob)
	
 
  
	#Refresh the project
	Shade.project.refresh(true)
	
	#Explicitly say that the grammar is saved
	Shade.project.execution.grammar.saved = true
	
  

  Shade.grammar_loaded=("SQUARE")
	
	#Set showing text to false
	Shade.show_text = false
	
	#Set scripting robot to nil
	Shade.robot = nil
	
	#Set contour face to nil
	Shade.contour_face = nil
	
	#Set montaner status to nil
	Shade.montaner_status = nil
	
	#Set montaner actions to nil
	Shade.montaner_actions = nil
	
	#Set montaner shape to nil
	Shade.montaner_shape = nil
	
	#Set previous montaner shape to nil
	Shade.previous_montaner_shape = nil
	
	#Set Montaner history to nil
	Shade.montaner_history = Hash.new(nil)
	
	Shade.flats_generated = false
	
	#Set list of constraint names and classes
	ShadeUtils.add_cg_names()
	
	#Search for custom constraints
	ShadeUtils.load_custom_constraints()
	
	#Search for custom goals
	ShadeUtils.load_custom_goals()
	
	html_path = Sketchup.find_support_file "info.html" ,Constants::HTML_DIR
		name_dialog = start_tutorial_dialog("info.html")
		name_dialog.set_file(html_path)
		name_dialog.show()
	
}